#include <stdio.h>

#include "global_types.h"
#include "control/device_sync.h"

static void print_device_sync_error_message(error_code_t err);

static void print_device_sync_error_message(error_code_t err)
{
	if (err==RESULT_NORESOURCES)
		fprintf(stderr, "Error: Out of memory.\n");
	if (err==RESULT_TIMEOUT_EXPIRED)
	    fprintf(stderr, "Timeout expired.\n");
}

int main(int argc, char* argv[])
{
	error_code_t result;
    int ret_val=0;

	result=device_sync_init(argc,argv);
	if (result==RESULT_OK)
		result=device_sync_start();

	  if (result!=RESULT_OK)
	  {
		  print_device_sync_error_message(result);
		  if (result==RESULT_HELP_PRINTED)
			  ret_val=1;
		  else
			  ret_val=2;
	  }

	device_sync_deinit(result==RESULT_TIMEOUT_EXPIRED);

	return ret_val;
}
